# noteクリエイターダッシュボード

noteクリエイター向けの分析ダッシュボードアプリケーションです。クリエイターIDを入力することで、公開されている記事情報（タイトル、スキ数、公開日時など）を分析できます。

## 機能

- ID/PASSによるログイン認証
- クリエイターID検索
- 公開記事の一覧表示
- スキ数の統計分析（総数、平均）

## 技術スタック

- バックエンド: PHP 7.4+
- フロントエンド: HTML/CSS/JavaScript
- データベース: MySQL 5.7+
- API: note API v2（公開エンドポイントのみ）

## セットアップ

### 1. データベースの準備

MySQLデータベースを作成し、スキーマを適用します。

```sql
CREATE DATABASE note_dashboard CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE note_dashboard;
SOURCE sql/schema.sql;
```

### 2. 設定ファイルの編集

`config/database.php` を編集して、データベース接続情報を設定します。

環境変数を使用する場合:
```bash
export DB_HOST=localhost
export DB_NAME=note_dashboard
export DB_USER=your_username
export DB_PASS=your_password
```

または、`config/database.php` 内の定数を直接編集します。

### 3. 初期ユーザーの作成

コマンドラインから初期ユーザーを作成します。

```bash
php setup/init_user.php admin your_password admin@example.com
```

### 4. Webサーバーの設定

Apache/Nginxでドキュメントルートをプロジェクトディレクトリに設定します。

Apacheの場合、`.htaccess` が有効になっていることを確認してください。

## ファイル構成

```
/
├── index.php          # メインダッシュボード（認証必須）
├── login.php          # ログインフォーム
├── logout.php         # ログアウト処理
├── config/
│   └── database.php   # DB接続設定
├── includes/
│   └── auth.php       # 認証ヘルパー関数
├── api/
│   └── fetch_creator_data.php  # note API呼び出し（認証必須）
├── assets/
│   ├── css/
│   │   └── style.css
│   └── js/
│       └── app.js
├── setup/
│   └── init_user.php  # 初期ユーザー作成スクリプト
└── sql/
    └── schema.sql     # DBスキーマ
```

## セキュリティ

- パスワードは `password_hash()` でハッシュ化
- セッション管理によるアクセス制御
- CSRF対策（トークン検証）
- SQLインジェクション対策（PDO prepared statements）
- XSS対策（出力時のエスケープ）

## 制約事項

- note APIは非ログイン公開情報のみを利用
- PV数などの非公開データは取得不可

## ライセンス

MIT License
